import re
import os


if __name__ == '__main__':

    nodes = ['EEF', 'MC6', 'FMB']
    basedir = os.path.dirname(__file__)
    fwdir = os.path.join(basedir, '..', '..', '..', 'HH-Firmware', 'STM32Projects')

    def parse_io_array_in_urpc_main(node, array):

        with open(os.path.join(fwdir, node, 'Source', 'URPC_main.cpp'), mode='r') as urpc_main:

            while f"{array}::instances[]" not in urpc_main.readline():
                pass

            result = ''
            reserved = 0
            for line in urpc_main:
                line = line.strip()
                if re.match('^};', line):
                    break
                if re.match('^//.*', line):
                    continue
                io = re.search('&(?P<name>\w+),\s*//(?P<comment>.*)', line)
                if io is not None:
                    name = io.group('name').upper()
                    name += ' = auto()' if result != '' else ' = 0'
                    comment = io.group('comment').upper().strip()
                    result += f"    {name:43} # {comment}\n"
                    continue
                nullptr = re.search('nullptr,\s*//(?P<comment>.*)', line)
                if nullptr is not None:
                    reserved += 1
                    name = f"RESERVED{reserved}"
                    name += ' = auto()' if result != '' else ' = 0'
                    comment = nullptr.group('comment').upper().strip()
                    result += f"    {name:43} # {comment}\n"
                    continue

                raise Exception(f"Failed to parse line: '{line}'")

            return result if result != '' else '    pass\n'


    with open(os.path.join(basedir, 'node_io.py'), mode='w') as file:

        file.write(f"from enum import IntEnum, auto\n\n")
        file.write(f"# Enums for the inputs and outputs of the node endpoints\n\n")

        for node in nodes:
            file.write(f"# {node} ##################################################################################################################\n\n")
            file.write(f"class {node}DigitalOutput(IntEnum):\n")
            file.write(parse_io_array_in_urpc_main(node, array='DOut'))
            file.write(f"\n\n")
            file.write(f"class {node}DigitalInput(IntEnum):\n")
            file.write(parse_io_array_in_urpc_main(node, array='DIn'))
            file.write(f"\n\n")
            file.write(f"class {node}AnalogOutput(IntEnum):\n")
            file.write(parse_io_array_in_urpc_main(node, array='AOut'))
            file.write(f"\n\n")
            file.write(f"class {node}AnalogInput(IntEnum):\n")
            file.write(parse_io_array_in_urpc_main(node, array='AIn'))
            file.write(f"\n\n")
            file.write(f"class {node}PWMOutput(IntEnum):\n")
            file.write(parse_io_array_in_urpc_main(node, array='PWM'))
            file.write(f"\n\n")

        file.write(f"########################################################################################################################\n")
